# -*- coding: utf-8 -*-

# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt

"""
Tracé du diagramme de Bode d'un filtre d'ordre 2

Fonction de transfert complexe H =  H0*Numérateur /(1+jf/(Qf0) + (jf/f0)^2)
        Passe-bas :   Numérateur = 1
        Passe-bande : Numérateur = jf/Qf0 
        Passe-haut :  Numérateur = (jf/f0)**2
"""

# Valeurs numériques des constantes du filtre
#---------------------------------------------------------------
f0 = 550          # CHOISIR LA VALEUR DE f0 en Hz, fréquence centrale
H0 = 1            # choisir la valeur de H0
Q = 2450           # choisir la valeur de Q, facteur de qualité
#---------------------------------------------------------------


n = 2000                                # nombre de points
f = np.logspace(-2, 2, n+1)*f0          # n intervalles, entre 10^-2.f0 et 10^2.f0 ; n+1 valeurs


#Définition de la fonction de transfert selon la nature du filtre choisi, décommenter'

def H(H0, f0, Q, f):                 # ordre des variables arbitraire, à conserver à chaque appel de fonction
    num = 1                          # passe-bas 
    #num = 1j*f/(Q*f0)               # passe-bande
    #num = (1j*f/f0)**2              # passe-haut   
    return H0*num/(1 + 1j*f/(Q*f0) + (1j*f/f0)**2)


#Définition du diagramme de Bode
    
GdB = 20*np.log10(np.abs(H(H0, f0, Q, f)))
phi = np.angle(H(H0, f0, Q, f), deg=True)

#Tracé de GdB et phi en concordance de fréquence
plt.subplot(211)
plt.semilogx(f, GdB, label=f'Q = {Q}')
plt.legend(loc='lower center') 
plt.title(f'Diagramme de Bode ordre 2, H0={H0}, f0 = {f0} Hz')
plt.ylabel('GdB')
plt.grid()

plt.subplot(212)
plt.semilogx(f, phi, label=f'Q = {Q}')
plt.legend(loc='center right') 
plt.ylabel('phase (°)')
plt.xlabel('f (Hz)')
plt.grid()

plt.show()

